﻿//////////////////////////////////////////////
// EditBox.h
//
//////////////////////////////////////////////

/// Defines / Macro --------------------------

#pragma once

/// Forward decl -----------------------------

namespace nkWinUi
{
	class System ;
}

/// Includes ---------------------------------

// nkWinUi
#include "Component.h"

#include "../Dll/DllDefines.h"

#include "../Inputs/CharEventData.h"

// nkMemory
#include <NilkinsMemory/Containers/String.h>

#include <NilkinsMemory/Pointers/UniquePtr.h>

/// Class ------------------------------------

namespace nkWinUi
{
	class DLL_WINUI_EXPORT EditBox : public Component
	{		
		public :
		
			// Constructeur, destructeur
			EditBox (System* system) noexcept ;
			virtual ~EditBox () ;

			// Getters
			std::function<bool (EditBox*, const CharEventData&)> getCharCallback () const ;

			// Setters
			virtual void setOnlyNumbers (bool value) ;
			virtual void setPlaceHolder (nkMemory::StringView text) ;
			virtual void setCaretPosition (unsigned int letterIndex) = 0 ;
			void setCharCallback (std::function<bool (EditBox*, const CharEventData&)> value) ;

			// Import / Export
			virtual void exportIntrospection (nkExport::Node* rootNode) override ;
			virtual void importClassFromTree (nkExport::Node* rootNode) override ;

		public :

			// Statics
			static nkMemory::UniquePtr<EditBox> create (System* system = nullptr) ;

		protected :

			// Attributes
			std::function<bool (EditBox*, const CharEventData&)> _charCallback ;

			nkMemory::String _placeHolder ;
			bool _onlyNumbers ;

	} ;
}